/** @format */

import { services, checkParams, registeInfos, preUpdate } from '../decorator/common'
import { resultsModel } from '../sdk'
import { CommonUserService, CommonAccessService } from '../service/common'
import { noCheckUser } from '../decorator/common'
export default class LoginController {
  /**
   *  登录接口, 初始化/更新用户信息
   *
   *  updateFirstLoginToday 当天第一次登陆的操作 如增加 3次游戏次数 gameTimes
   *
   *  updateFirstLoginToday({ $inc: { gameTime: 3}})
   */
  @checkParams(['activityId', 'userNick', 'avatar', 'isFollow', 'isVip'])
  @noCheckUser
  @registeInfos(['vipInfo'])
  @services([CommonUserService, CommonAccessService])
  async login(
    context: IContext<IParams>,
    { userInfo, activityInfo, vipInfo }: IControllerInfos,
    [userService, accessService]: [CommonUserService, CommonAccessService]
  ): Promise<IResult<{ openId: string; firstLoginToday: boolean; newUser: boolean }>> {
    const updatedUserInfo = await userService.doLogin(userInfo, vipInfo, activityInfo)
    // access表
    const openIdResult = await accessService.addAccess(updatedUserInfo, vipInfo)

    return resultsModel.success({
      ...openIdResult
    })
  }
}
