/** @format */
import { services, checkParams } from '../../decorator/common'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonUserService } from '../../service/common'

export default class UserController {
  /**
   *  获取会员信息
   */
   @checkParams(['activityId', 'isVip'])
   @services([CommonUserService])
   async getVipInfo(
     context: IContext<IParams>,
     { activityInfo, userInfo }: IControllerInfos,
     [commonUserService]: [CommonUserService]
   ) {
     const commonUserGetShopVipResult1 = await commonUserService.getShopVip(context, activityInfo)
     return resultsModel.success({
       ...commonUserGetShopVipResult1
     })
   }
   /**
   *  获取排行榜
   */
  @checkParams(['activityId', 'key', 'timeKey', 'limit'])
  @services([CommonUserService])
  async getRankList(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonUserService]: [CommonUserService]
  ) {
    const commonUserGetMyRankInfoResult1 = await commonUserService.getMyRankInfo(
      context.data.key,
      context.data.timeKey,
      userInfo
    )
    const commonUserGetRankResult2 = await commonUserService.getRank(
      context.data.key,
      context.data.timeKey,
      context.data.limit
    )
    return resultsModel.success({
      ...commonUserGetMyRankInfoResult1,
      ...commonUserGetRankResult2
    })
  }
}
