/** @format */
import { services, checkParams } from '../../decorator/common'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonStatService } from '../../service/common'

export default class StatController {
  /**
   *  增加埋点记录
   */
  @checkParams(['activityId', 'key'])
  @services([CommonStatService])
  async addStat(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonStatService]: [CommonStatService]
  ) {
    const commonStatAddStatResult1 = await commonStatService.addStat(context.data.key, userInfo)
    return resultsModel.success({
      ...commonStatAddStatResult1
    })
  }
  /**
   *  统计数据
   */
  @checkParams(['activityId', 'startDay', 'endDay'])
  @services([CommonStatService])
  async getStats(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonStatService]: [CommonStatService]
  ) {
    const commonStatGetStatsResult1 = await commonStatService.getStats(
      context.data.activityId,
      context.data.startDay,
      context.data.endDay
    )
    const commonStatBuildExcelResult2 = await commonStatService.buildExcel(
      context.data.startDay,
      context.data.endDay,
      commonStatGetStatsResult1
    )
    return resultsModel.success({
      xlsxData: commonStatGetStatsResult1,
      ...commonStatBuildExcelResult2
    })
  }
}
