/** @format */
import { services, checkParams, registeInfos, preCheck } from '../../decorator/common'
import { checkActivityTime, checkInviteId, checkNewVip, checkHelpRecord } from '../../utils/common/check'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonUserService, CommonTaskService, CommonStatService } from '../../service/common'

export default class ShareController {
  /**
   *  获取邀请信息
   */
  @checkParams(['activityId'])
  @services([CommonUserService])
  async getShareInfo(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonUserService]: [CommonUserService]
  ) {
    const commonUserQueryDataByKeyResult1 = await commonUserService.queryDataByKey(
      'remainTimes.invites',
      userInfo,
      'rewards'
    )
    return resultsModel.success({
      ...commonUserQueryDataByKeyResult1
    })
  }
  /**
   *  完成分享
   */
  @checkParams(['activityId', 'inviteId', 'isVip'])
  @registeInfos(['vipInfo'])
  @services([CommonTaskService, CommonStatService])
  @preCheck([checkActivityTime, checkInviteId, checkNewVip, checkHelpRecord])
  async doHelp(
    context: IContext<IParams>,
    { activityInfo, userInfo, vipInfo }: IControllerInfos,
    [commonTaskService, commonStatService]: [CommonTaskService, CommonStatService],
    { inviteUserInfo }: IPreCheckData
  ) {
    const commonTaskCompleteTaskResult1 = await commonTaskService.completeTask('invite', activityInfo, inviteUserInfo)
    const commonStatAddStatResult2 = await commonStatService.addStat(0, userInfo)
    return resultsModel.success({
      ...commonStatAddStatResult2
    })
  }
}
