/** @format */
import { services, checkParams, noCheckUser, registeInfos } from '../../decorator/common'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonUserService, CommonAccessService } from '../../service/common'

export default class LoginController {
  /**
   *  登录接口, 初始化/更新用户信息
   */
  @checkParams(['activityId', 'userNick', 'avatar', 'isFollow', 'isVip'])
  @noCheckUser
  @registeInfos(['vipInfo'])
  @services([CommonUserService, CommonAccessService])
  async login(
    context: IContext<IParams>,
    { activityInfo, userInfo, vipInfo }: IControllerInfos,
    [commonUserService, commonAccessService]: [CommonUserService, CommonAccessService]
  ) {
    const commonUserDoLoginResult1 = await commonUserService.doLogin(userInfo, vipInfo, activityInfo)
    const commonAccessAddAccessResult2 = await commonAccessService.addAccess(commonUserDoLoginResult1, vipInfo)
    return resultsModel.success({
      ...commonUserDoLoginResult1,
      ...commonAccessAddAccessResult2
    })
  }
}
