/** @format */
import { getToday } from '../getToday'
import { insertTaskRecord } from '../task'
import { isNewVip, setNewVipUserData } from '../userUpdate'

export default async function updateVip(
  context: IContext<IParams>,
  { vipInfo, userInfo, activityInfo }: IControllerInfos
): Promise<IPreUpdateQuery> {
  let { member } = userInfo

  const memberReWards = activityInfo?.tasks?.member?.value

  if (isNewVip(userInfo, vipInfo)) {
    await insertTaskRecord(context, userInfo, 'member')
    return {
      $set: {
        member: setNewVipUserData(member)
      },
      $inc: {
        'remainTimes.member': +memberReWards,
        [`taskInfo.${getToday()}.member`]: 1
      }
    }
  }
}
