/** @format */

import { getToday } from '../getToday'
import { getCompleteTaskTimes, insertTaskRecord } from '../task'

export default async function updateSignTask(
  context: IContext<IParams>,
  { userInfo, activityInfo }: IControllerInfos
): Promise<IPreUpdateQuery | undefined> {
  if (!activityInfo?.tasks?.sign) return
  const taskType = 'sign'
  // 获取签到奖励
  const { value } = activityInfo?.tasks?.[taskType] || {}

  const { todayCompleteTimes } = getCompleteTaskTimes(taskType, userInfo)
  const today = getToday()

  // 今天没有有完成记录
  if (todayCompleteTimes === 0) {
    await insertTaskRecord(context, userInfo, taskType)
    return {
      $inc: {
        'remainTimes.sign': value || 0,
        [`taskInfo.${today}.sign`]: 1
      }
    }
  }
}
