/** @format */
import { getToday } from '../getToday'
import { getCompleteTaskTimes } from '../task'
import { TASK_RATE_TYPE } from '../../../constants'
import { getUserOrderlist } from '../getUserOrderlist'
import { dbFind, dbInsertMany } from '../mongodb'
import { TASK_RECORD_DN_NAME } from '../../../db'

export default async function updateOrderGoods(
  context: IContext<IParams>,
  { userInfo, activityInfo }: IControllerInfos
): Promise<IPreUpdateQuery> {
  const taskType = 'orderGoods'
  const { value, itemIds, taskRateType, times } = activityInfo?.tasks?.[taskType] || {}
  const { completeTimes, todayCompleteTimes } = getCompleteTaskTimes(taskType, userInfo)

  const {
    data: { activityId },
    openId
  } = context
  const { userNick } = userInfo

  if (!activityInfo?.tasks?.[taskType]) return {}
  // 永久任务且已完成
  if (taskRateType === TASK_RATE_TYPE.FOREVER && completeTimes) {
    return {}
  }

  // 每日限制完成且完成次数达到限制
  const today = getToday()
  if (taskRateType === TASK_RATE_TYPE.EVERYDAY && todayCompleteTimes >= times) {
    return {}
  }

  const orderResult = await getUserOrderlist(
    this.context,
    //@ts-ignore
    userInfo.createTime || activityInfo?.startTime || Date.now(),
    Date.now()
  )

  const itemIdsArr = itemIds.split(',').map(v => +v)

  let projection = {
    $inc: {
      [`remainTimes.${taskType}`]: 0
    },
    $set: {}
  }

  // let targetOrders = userInfo?.taskInfo?.[today]?.[taskType] || []
  let targetOrders = await dbFind<ITaskRecord>(context, TASK_RECORD_DN_NAME, {
    activityId,
    openId,
    taskType,
    createDay: getToday()
  })
  orderResult.forEach(v => {
    // @ts-ignore
    // 商品订单包含目标商品 且orderId为新订单
    if (itemIdsArr.includes(v.itemId) && !taskInfo.some(order => order.orderId === v.orderId)) {
      if (taskRateType === TASK_RATE_TYPE.EVERYDAY && targetOrders.length >= times) {
        return
      }
      projection.$inc[`remainTimes.${taskType}`] += +value
      targetOrders.push({
        activityId,
        taskType,
        userNick,
        openId,
        createDay: getToday(),
        itemId: v.itemId,
        orderId: v.orderId,
        payTime: v.payTime,
        tId: v.tId,
        price: v.price,
        updateTime: Date.now(),
        createTime: Date.now()
      })
    }
    if (targetOrders?.length) {
      dbInsertMany(context, TASK_RECORD_DN_NAME, targetOrders)
      projection.$set[`taskInfo.${today}.${taskType}`] = targetOrders.length
    }
  })

  return projection
}
