/** @format */

import * as dayjs from 'dayjs'
import { uniq } from 'lodash'
import { getToday } from './getToday'

const isLeapYear = (year: number) => (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0

// 获取最大连续签到天数
export const getMaxContinusSignDays = (signInfoList: ISignInfoAggregate[]): number => {
  const minYear = Math.min.apply(
    null,
    signInfoList.map(v => +v.y)
  )
  const list: number[] = signInfoList
    .map(v => {
      const gap = (isLeapYear ? 366 : 365) * (v.y - minYear)
      return gap + v.d
    })
    .sort((a, b) => a - b)

  if (list.length === 0) return 0
  let m = uniq(list.sort((a, b) => a - b))
  let max = 0
  for (let i = 0; i < m.length; i++) {
    let idx = 0
    while (m[i + 1] - m[i] === 1) {
      idx++
      i++
      max = Math.max(idx, max)
    }
  }
  return max + 1
}

// 获取某天是否签到
export const getSignedByDay = (signInfoList: ISignInfoAggregate[], day = getToday()): boolean => {
  return signInfoList.some(v => dayjs(v.signTime).format('yyyy/MM/dd') === day)
}
