/** @format */

import { resultsModel } from '../sdk'
import { checkParams, services } from '../decorator/common'
import { CommonStatService } from '../service/common'

/** @format */
export default class StatController {
  /**
   *  增加埋点记录
   */
  @checkParams(['activityId', 'type'])
  @services([CommonStatService])
  async addStat(context: IContext<IParams>, { userInfo }: IControllerInfos, [statService]: [CommonStatService]) {
    const { type } = context.data
    const result = await statService.addStat(type, userInfo)
    return resultsModel.success(result)
  }
  /**
   *  统计数据
   */
  @checkParams(['activityId', 'startDay', 'endDay'])
  @services([CommonStatService])
  async getStats(context: IContext<IParams>, {}: IControllerInfos, [statService]: [CommonStatService]) {
    const { activityId, startDay, endDay } = context.data

    const xlsxData = await statService.getStats(activityId, startDay, endDay)

    const result = await statService.buildExcel(startDay, endDay, xlsxData)

    return resultsModel.success(result)
  }
}
