/** @format */

// 养成相关

/**
 *  根据经验配置获取当前等级
 *
 * @export
 * @param {number} exp
 * @param {IExpConfig[]} expConfig
 * @return {*}
 */
export function formatExp(exp: number, expConfig: IExpConfig[]) {
  const currExpInfo =
    expConfig.find((config, i) => {
      const fromExp = i === 0 ? 0 : expConfig[i - 1]?.exp
      const toExp = config.exp
      return exp >= fromExp && exp < toExp
    }) || ({} as IExpConfig)

  return {
    exp,
    expLevel: currExpInfo?.level || 'max'
  }
}

/**
 *  计算需要新创建持续作物的数量
 *
 * @export
 * @param {IContinuedGain[]} continuedGains
 * @param {IGains} gainConfig
 * @return {*}  {number}
 */
export function countNewCreateContinuedGains(
  userInfo: IUserInfo,
  continuedGains: IContinuedGain[],
  gainConfig: IGains,
  speedUpCdTime?: number
): number {
  const { maxLimit, cdTime } = gainConfig
  const now = Date.now()
  const finalCDTime = speedUpCdTime || cdTime

  // 已经超过最大限制
  if (continuedGains.length >= maxLimit) return 0

  // const gapTime = now -
}
