/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { formatVipCbUrl, getShopVip } from '../vip'
import { TOTAL_GUIDE_STEP } from '../../../constants'

export async function checkGuideStep(context: IContext<IParams>, { userInfo }: IControllerInfos) {
  const { guideStep } = userInfo

  if (guideStep >= TOTAL_GUIDE_STEP) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '该引导已经更新~')
}

/**
 * 检查牧场/宠物的名字
 *
 * @export
 * @param {number} [maxLength=7]
 * @return {*}
 */
export function checkName(maxLength = 7): IFunction {
  return async function (context: IContext<IParams>, { userInfo }: IControllerInfos) {
    const { name } = userInfo

    if (name) return resultsModel.error(CODE_TYPES.ERROR_HAVE_GIVE_NAME, '您已经命名过~')

    if (name?.length > maxLength)
      return resultsModel.error(CODE_TYPES.ERROR_MAX_LENGTH_NAME, `您的命名超过最大长度，最多${maxLength}个字符`)
  }
}
