/** @format */
type IUserInfo = ICustomUserInfo & ICommonUserInfo

type IPlantType = 'banana' | 'apple'
interface IPlantInfo {
  index: number
  type: IPlantType
  progress: number
  level: number
  nextTime: number
}

type TGainsKey = 'milkDrops'
interface IGains {
  key: TGainsKey
  maxLimit: number
  cdTime: number
  value: number
}
interface ICustomUserInfo {
  // 游戏类
  gameTimes?: number
  maxScore?: number
  totalScore?: number
  updateScoreTime?: number
  // 养成
  guideStep: number
  name: string
  plants?: IPlantInfo[]
  continuedGains?: IContinuedGain[]
  exp?: number
  storages?: {
    [key in IPlantType]?: number
  }
}

interface ICommonUserInfo {
  _id?: string
  id?: string
  activityId: string
  avatar: string
  userNick: string
  openId: string
  createTime: number
  updateTime: number
  createDay?: string
  inviteId?: string
  member?: IMemberInfo
  follow?: IFollowInfo
  remainTimes?: IRemainTimesInfo
  taskInfo?: object
  login?: object
}

interface IRemainTimesInfo {
  invites?: number
  browseGoods?: number
  joinGroup?: number
  member?: number
  follow?: number
  orderGoods?: number
  collectGoods?: number
  exchangeCredits?: number
  jumpLink?: number
  sign?: number
}

interface IMemberInfo {
  flag: boolean
  newMember?: boolean
  bememberTime?: number
  bememberDay?: string
}

interface IFollowInfo {
  flag: boolean
  newFollow?: boolean
  followTime?: number
  followDay?: string
}

interface ITaskDetail {
  createTime: number
  openId?: string
  orderId?: string
  itemId?: string
  payTime?: string
}
