/** @format */

type IGrowInteractTaskType = 'bath' | 'music'

type IGrowInteractTaskConfig = {
  [key in IGrowInteractTaskType]: {
    cdTime: number
    rewards: number
    dayLimit?: number
    totalLimit?: number
  }
}

interface ISeedConfig {
  level: number
  cdTime: number
}

type ISeed = {
  name: string
  type: IPlantType
  config: ISeedConfig[]
}

interface IExpConfig {
  level: number
  exp: number
}

interface IDBInteractTasks {
  openId: string
  userNick: string
  activityId: string
  type: IGrowInteractTaskType
  createTime: number
  updateTime: number
  createDay: string
}

interface IInjectedGrowInfoData {
  expLevel?: any
}
interface IContinuedGain {
  pos: number // 位置
  value: number // 数据
  createTime: number // 创建时间
}
