/**
 * 基本信息
 *
 * @format
 */

import { BaseDao, TBAPIS } from '../../sdk'
import { ACTIVITY_CONFIG_DB_NAME } from '../../db'
import { ACTIVITY_OPEN_PRIZE_STATUS, ACTIVITY_STATUS } from '../../constants'
import UserService from './user.service'
import { injectGrowExp } from '../../decorator/common/InjectGrowInfo'

export default class GrowService extends UserService {
  context: IContext<any>
  activitydao: IBaseDao
  constructor(context: IContext<any>) {
    super(context)
    this.context = context
    this.activitydao = new BaseDao(context, ACTIVITY_CONFIG_DB_NAME)
  }

  @injectGrowExp
  async getGrowInfo(
    context: IContext<IParams>,
    activityInfo: IActivityInfo,
    userInfo: IUserInfo,
    injectedGrowInfoData: IInjectedGrowInfoData = {}
  ) {
    return {
      ...injectedGrowInfoData
    }
  }
}
