/** @format */

import { getConfig } from '../../config'
import { formatExp } from '../../utils/common/grow'

export function injectGrowExp(target: any, name: string, descriptor: PropertyDescriptor) {
  const method = descriptor.value
  descriptor.value = async function (
    context: IContext<IParams>,
    activityInfo: IActivityInfo,
    userInfo: IUserInfo,
    gameInfoData = {}
  ) {
    const { exp } = userInfo
    const { EXP_CONFIG } = getConfig(context)
    const expLevel = formatExp(exp, EXP_CONFIG)

    return method.apply(this, [context, activityInfo, userInfo, { ...gameInfoData, expLevel }])
  }
}

export function injectContinuedGains(target: any, name: string, descriptor: PropertyDescriptor) {
  const method = descriptor.value
  descriptor.value = async function (
    context: IContext<IParams>,
    activityInfo: IActivityInfo,
    userInfo: IUserInfo,
    gameInfoData = {}
  ) {
    let { continuedGains } = userInfo

    const {
      CONTINUED_GAINS_CONFIG: { maxLimit }
    } = getConfig(context)

    if (continuedGains.length < maxLimit) {
    }
    return method.apply(this, [context, activityInfo, userInfo, { ...gameInfoData }])
  }
}
