/** @format */
/** @format */

import { services, preCheck, registeInfos, preUpdate, checkParams } from '../decorator/common'
import { resultsModel } from '../sdk'
import { CommonStatService, CommonGrowtaskService } from '../service/common'
import { STAT_TYPE, TOTAL_GUIDE_STEP } from '../constants'
import {
  checkActivityTime,
  checkInviteId,
  checkHelpRecord,
  checkNewVip,
  checkGuideStep,
  checkName
} from '../utils/common/check'
import { updateHelpRecord, updateVip } from '../utils/common/update'
import { getTask } from '../utils'
import GrowService from '../service/common/grow.service'

export default class Grow {
  /**
   *  新手引导
   */
  @checkParams(['activityId', 'guideStep'])
  @services([GrowService])
  @preCheck([checkGuideStep])
  async doGuide(context: IContext<IParams>, { userInfo }: IControllerInfos, [growService]: [GrowService]) {
    const { guideStep } = context.data

    await growService.updateUser(userInfo._id, {
      $set: {
        guideStep
      }
    })

    return resultsModel.success({
      guideStep,
      isDone: guideStep === TOTAL_GUIDE_STEP
    })
  }

  /**
   *  命名
   */
  @checkParams(['activityId', 'name'])
  @services([GrowService])
  @preCheck([checkName(8)])
  async giveName(context: IContext<IParams>, { userInfo }: IControllerInfos, [growService]: [GrowService]) {
    const { name } = context.data

    const result = await growService.updateUser(userInfo._id, {
      $set: {
        name
      }
    })
    return resultsModel.success(result)
  }

  /**
   *  获取养成信息
   */
  @checkParams(['activityId'])
  @services([GrowService])
  async getGrowGameInfo(
    context: IContext<IParams>,
    { userInfo, activityInfo }: IControllerInfos,
    [growService]: [GrowService]
  ) {
    const growGameInfo = await growService.getGrowInfo(context, activityInfo, userInfo)

    return resultsModel.success(growGameInfo)
  }
}
