/** @format */
import { services, checkParams, noCheckUser } from '../../decorator/common'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonBaseService } from '../../service/common'

export default class BaseController {
  /**
   *  活动基本信息
   */
  @checkParams(['activityId'])
  @noCheckUser
  @services([CommonBaseService])
  async getActivityBaseInfoById(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonBaseService]: [CommonBaseService]
  ) {
    const commonBaseGetBaseInfoResult1 = await commonBaseService.getBaseInfo(context.data.activityId)
    return resultsModel.success({
      ...commonBaseGetBaseInfoResult1
    })
  }
}
