/** @format */

import { appId } from '../constants'
import { IConfig } from './index'

export const cfg: IConfig = {
  INTERACT_TASKS: {
    bath: {
      cdTime: 10000,
      rewards: 4
    },
    music: {
      cdTime: 10000,
      rewards: 4
    }
  },
  SEEDS: [
    {
      name: '苹果',
      type: 'apple',
      config: [
        {
          level: 1,
          cdTime: 2 * 60 * 60 * 1000
        }
      ]
    }
  ],
  CONTINUED_GAINS_CONFIG: {
    key: 'milkDrops',
    maxLimit: 8,
    value: 1,
    cdTime: 2 * 60 * 60 * 1000
  },
  EXP_CONFIG: [
    {
      level: 1,
      exp: 1000
    },
    {
      level: 2,
      exp: 8000
    }
  ]
}
