/** @format */

import { cfg as online } from './online'
import { cfg as test } from './test'

export interface IConfig {
  vipCallBackUrl?: string
  INTERACT_TASKS: IGrowInteractTaskConfig
  SEEDS: ISeed[]
  CONTINUED_GAINS_CONFIG: IGains
  EXP_CONFIG: IExpConfig[]
}

const configs = {
  online,
  pre: online,
  test,
  mock: test
}

// 根据服务环境获取配置
export const getConfig = (context: IContext<{}>): IConfig => {
  const env = context.env
  return configs[env] || configs.online
}
