/**
 * 用户相关方法
 */
const { BaseDao, TBAPIS } = require('../sdk');

const BaseService = require('./base.service');

const { USER_DB_NAME } = require('../db');
class UserService extends BaseService{
  constructor(context) {
    super(context);
    this.userdao = new BaseDao(context, USER_DB_NAME);
  }
  /**
   * @desc 获取当前打开活动的用户详情
   * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
   */
  async getUserInfo() {
    let { openId, data } = this.context;
    let { activityId } = data;
    let record = await this.userdao.findOne({openId, activityId });
    return record;
  }

  /**
   * @desc 根据inviteId获取用户详情
   * @desc 常用于助力分享码为用户openId, 被邀请人打开活动助力时需要获取邀请人的用户详情
   * @param {邀请人的openId} inviteId 
   * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
   */
  async getUserInfoByOpenId(inviteId) {
    let { activityId } = this.context.data;
    let record = await this.userdao.findOne({openId: inviteId, activityId });
    return record;
  }

  /**
   * @desc 获取是否是会员
   * @param {调用淘宝接口的session} session 
   * @returns {isvip: boolean(是否是会员), url: string(入会链接) }
   */
  async getShopVip(session) {
    // 会员mock，当传递的参数有vipmock: true，则表示已经是会员
    let { vipmock = false} = this.context.data;
    if (vipmock) {
      return {
        isvip: true
      }
    }
    let result = {}
    let shopUrl = {};
    try{
      result = await TBAPIS.queryVipinfo(this.context, session);
      shopUrl = await TBAPIS.getShopVipUrl(this.context, session, {
        "source": "isvapp", "entrance": "duiba"
      });
    }catch(e) {
      console.log(e);
    }
    console.log(`result, shopUrl`, result, shopUrl);
    return {
      isvip: !!(result.result && result.result.member_info),
      url: shopUrl.result && shopUrl.result.result
    }
  }

  /**
   * @desc 更新用户表
   * @param {用户的主键id} _id 
   * @param {更新的对象} document 
   * @returns 若更新成功，返回为1； 若更新失败，返回为 0 或系统直接报错
   */
  async updateUser(_id, document) {
    console.log(document);
    return await this.userdao.update({_id}, {$set: {
      ...document,
      updateTime: Date.now()
    }});
  }
  /**
   * @desc 根据用户主键id查找用户详情
   * @param {用户的主键id} _id 
   * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
   */
  async getUserInfoById(_id) {
    return await this.userdao.findOne({_id});
  }
}

module.exports = UserService;