const { pipeActivityInfo } = require('./base.controller');
const UserService = require('../service/user.service');
const AwardsService = require('../service/awards.service');
const { CODE_TYPES } = require('../constants');
const { ResultsModel } = require('../sdk');
let resultModel = new ResultsModel();

/**
 * 我的奖品列表
 * @param {*} context 
 */
const getMyPrizeList = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束可以查看我的奖品
  if (pipeRes.code && pipeRes.code !== CODE_TYPES.ERROR_ACTIVITY_OVER.code) {
    return pipeRes;
  }
  let awardSer = new AwardsService(context);
  let result = await awardSer.getMyPrizeList({openId: context.openId, activityId: context.data.activityId});
  return resultModel.success(result);
}
/**
 * 领取实物
 * @param {*} context 
 */
const receiveObjectPrize = async(context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束可以领取实物
  if (pipeRes.code && pipeRes.code !== CODE_TYPES.ERROR_ACTIVITY_OVER.code) {
    return pipeRes;
  }
  let { provice, city, area, addressdetail, _id, name, phone, activityId } = context.data;
  if (!_id) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少_id`)
  }
  if (!name) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少name`)
  }
  if (!phone) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少phone`)
  }
  if (!provice) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少provice`)
  }
  if (!city) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少city`)
  }
  if (!area) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少area`)
  }
  if (!addressdetail) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少addressdetail`)
  }
  let awardSer = new AwardsService(context);
  let result = await awardSer.recieveObjectPrize(_id, {activityId, provice, city, area, addressdetail, name, phone});
  if (result.code) {
    return resultModel.error(result);
  }
  return resultModel.success(result);
}

/**
 * 权益重新领取
 * @param {*} context 
 */
const receiveEnamePrize = async(context) => {
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束可以领取权益
  if (pipeRes.code && pipeRes.code !== CODE_TYPES.ERROR_ACTIVITY_OVER.code) {
    return pipeRes;
  }
  let {_id} = context.data;
  if (!_id) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `缺少_id`)
  }
  let awardsSer = new AwardsService(context);
  let result = await awardsSer.recieveEnamePrize(_id, pipeRes._id);
  if (result.code) {
    return resultModel.error(result);
  }
  if (result.remark) {
    return resultModel.error(result, result.remark);
  }
  return resultModel.success(result);
}


module.exports = {
  getMyPrizeList,
  receiveObjectPrize,
  receiveEnamePrize
}