const { DEFAULT_CODE_TYPES } = require('./sdk');

let BusinessError = {
  // 更新重试失败(用于并发更新)
  ERROR_UPDATE_RETRY: {
    code: `210001`,
    defaultMsg: `系统错误`
  },
  // 活动不存在
  ERROR_NO_ACTIVITY: {
    code: `220001`,
    defaultMsg: `活动不存在`
  },
  // 活动未开始
  ERROR_ACTIVITY_NOSTART: {
    code: `220002`,
    defaultMsg: `活动未开始`
  },
  // 活动已结束
  ERROR_ACTIVITY_OVER: {
    code: `220003`,
    defaultMsg: `活动已结束`
  },
  // 用户不存在
  ERROR_NO_USER: {
    code: `310002`,
    defaultMsg: `用户不存在`
  },
  // 需要成为会员才能助力哦
  ERROR_NEEDMEMBER_DOHELP: {
    code: `310004`,
    defaultMsg: '需要成为会员才能助力哦'
  },
  // 任务奖励已领取
  ERROR_TASK_ALREADYRECEIVE: {
    code: `430002`,
    defaultMsg: `任务奖励已领取`
  },
  // 任务已完成
  ERROR_TASK_COMPLETE: {
    code: `430003`,
    defaultMsg: `任务已完成`
  },
  // 暂无次数可领取
  ERROR_TASK_NORECEIVE: {
    code: `430003`,
    defaultMsg: `暂无次数可领取`
  },
  ERROR_FORBIDDEN_OPE: {
    code: `530001`,
    defaultMsg: `非法操作`
  },
  ERROR_RECEIVE_PRIZE: {
    code: `630002`,
    defaultMsg: `奖励已领取`
  },
  ERROR_SEND_PRIZE: {
    code: `730001`,
    defaultMsg: `发奖失败`
  },
  ERROR_NO_PRIZE: {
    code: `730002`,
    defaultMsg: `奖品不存在`
  },
  ERROR_NO_STOCK: {
    code: `730003`,
    defaultMsg: `库存不足`
  },
  ERROR_PRIZE_EXPIRED: {
    code: `740001`,
    defaultMsg: `奖品已超过领取时间`
  }
}

 
const CODE_TYPES = Object.assign({}, DEFAULT_CODE_TYPES, BusinessError);

//tb 接口返回部分错误
const TBERROR = {
  'USER_PERMISSION_EXCEED_MAX_RIGHT_COUNT_IN_DAY': '今日领取达到上限，明日再来领取哦',
  'COUPON_INVALID_OR_DELETED': '权益无效或者被删除，请联系商家',
  'APPLY_OWNSELF_COUPON': '不能领取自己家店铺权益',
  'APPLY_SINGLE_COUPON_COUNT_EXCEED_LIMIT': '请至卡券包删除无用权益再领取',
  'NO_RIGHT_QUANTITY': '权益库存不足，请联系商家',
  'ERRORA_3_567': '领取失败，为风险用户',
  'Invalid session': '订购应用已过期，请联系商家处理',
  'NO_RIGHT_QUANTITY': '权益库存不足，请联系商家'
}

// 领取奖品状态
const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6
}
 
// 奖品类型
const PRIZE_TYPE = {
  ENAME: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANKS: 5
};
// C端的APP NAME
const C_APP_NAME = 'promotioncenter-<%=consumerId%>';

// 订单状态
const TAOBAO_SUCCESS_ORDER_STATUS = [
  "WAIT_SELLER_SEND_GOODS",
  "SELLER_CONSIGNED_PART",
  "WAIT_BUYER_CONFIRM_GOODS",
  "TRADE_BUYER_SIGNED",
  "TRADE_FINISHED",
  "PAID_FORBID_CONSIGN",
];
// 活动状态
const ACTIVITY_STATUS = {
  NORMAL: 1,
  DELETE: 2
};
let rand = (function(){
  let seed = (new Date()).getTime()
  function r(){
    seed = (seed*9301+49297)%233280
    return seed/(233280.0)
  }
  return function(number){
    return Math.ceil(r()*number)
  }
})()
module.exports = {
  CODE_TYPES,
  C_APP_NAME,
  TBERROR,
  DRAW_STATUS,
  PRIZE_TYPE,
  TAOBAO_SUCCESS_ORDER_STATUS,
  ACTIVITY_STATUS,
  rand
}