import * as tb from './core/tb';
import * as tbFn from './core/tbFn';
import * as tbMock from './core/tbMock';
import * as utils from './utils';
import * as constants from './constants';
import capi from './request/capi';
import capiFn from './request/capiFn';
import request from './request';
const isH5 = 'undefined' !== typeof window;

// 如果为h5环境走mock数据
let _tb = {};
Object.entries({ ...tb, ...tbFn }).forEach(([key, value]) => {
  _tb[key] = isH5 ? tbMock[key] : value;
});
export default {
  capi,
  capiFn,
  tb: _tb,
  utils,
  request,
  constants
}