import API from '../../api';
const app = getApp();
const { tbccTs } = app;
const {
  commonToast,
  simpleAlert,
  commonConfirm,
  getAuthUserInfo,
  getSystemInfo,
  getServerTime,
  favorShop,
  checkShopFavoredStatus,
  getUserAddress,
  collectGoods,
  checkGoodsCollectedStatus,
  openDetail,
  navigateToOutside,
  navigateTo,
  redirectTo,
  uploadImage,
  chattingSendCard,
  textRiskIdentification,
  setClipboard,
  getStorage,
  setStorage,
  navigateToTaobaoPage,
  taobaoReportClick, // 自定义分析数据的上报接口
  openMessage,// 打开BC客服聊天
  showSkuModal, // 显示指定商品 SKU 选择器
  hideSkuModal,// 隐藏正在展示的商品 SKU 选择器
  confirmCustomOrder,// 跳转订单页
} = tbccTs.tb;

const { dateFormatter, versionCompare } = tbccTs.utils;

Page({
  data: {
    uploadImgUrl: '',
    riskInput: ''
  },
  onLoad() {},
  bindKeyInput(e) {
    const { value } = e.detail;
    const { name } = e.target.dataset;
    this.setData({
      [name]: value,
    });
  },
  /**
   * toast提示
   */
  showCommomToast() {
    commonToast('tbcc', 3000, () => {
      console.log('tbcc toast loaded');
    });
  },
  /**
   * confirm弹窗
   */
  showCommomConfirm() {
    commonConfirm('提示', '内容', () => {
      commonToast('保存成功');
    });
  },
  /**
   * 获取用户授权信息
   */
  async getAuth() {
    const userInfo = await getAuthUserInfo().catch(err => {
      console.log('未授权成功', err);
    });
    if (userInfo) {
      console.log('userInfo', userInfo);
      const { nickName, avatar } = userInfo;
      app.nickName = nickName;
      app.avatar = avatar;
      simpleAlert(nickName);
    }
  },
  /**
   * 获取系统信息
   */
  async getSystemInfo() {
    const systemInfo = await getSystemInfo().catch(err => {
      console.log('获取系统信息失败', err);
    });

    if (systemInfo) {
      console.log('systemInfo', systemInfo);
      const { version } = systemInfo;
      const compareVersion = '9.8.0';
      const isNewVersion = versionCompare(version, compareVersion);
      simpleAlert('当前版本:' + version + `${isNewVersion ? '为新版本': '为老版本'}`);
    }
  },
  /**
   * 获取系统时间
   */
  async getServerTime() {
    const severTime = await getServerTime().catch(err => {
      console.log('获取系统时间失败', err);
    });
    simpleAlert('系统时间:' + dateFormatter(severTime, 'yyyy/MM/dd hh:mm:ss'));
  },
  /**
   * 关注店铺
   */
  async favorShop() {
    const sellerId = 628189716; // 百草味sellerId
    const favorStatus = await favorShop(sellerId).catch(err => {
      console.log('关注店铺失败', err);
    });
    commonToast(favorStatus ? '关注成功' : '关注失败');
  },
  /**
   * 查询店铺关注状态
   */
  async checkShopFavoredStatus() {
    const sellerId = 628189716; // 百草味sellerId
    const favoredStatus = await checkShopFavoredStatus(sellerId).catch(err => {
      console.log('查询关注店铺状态失败', err);
    });
    simpleAlert(favoredStatus ? '已关注店铺' : '未关注店铺');
  },
  /**
   * 获取用户收货地址
   */
  async getUserAddress() {
    const userAddress = await getUserAddress().catch(err => {
      commonToast(err.errorMessage);
    });
    if (userAddress) {
      console.log('userAddress', userAddress);
      const { name, phone, address } = userAddress.duibaAddress;
      commonConfirm('提示', '确认使用该收货地址：' + name + phone + address, () => {
        // TODO 保存接口
        commonToast('保存成功');
      });
    }
  },
  /**
   * 收藏商品
   */
  async collectGoods() {
    const itemId = 622499363381; // iPad Pro 为例
    const collectGoodsStatus = await collectGoods(itemId).catch(err => {
      console.log('收藏商品失败', err);
    });
    commonToast(collectGoodsStatus ? '收藏商品成功' : '收藏商品失败');
  },
  /**
   * 收藏商品
   */
  async checkGoodsCollectedStatus() {
    const itemId = 622499363381; // iPad Pro 为例
    const goodscollectedStatus = await checkGoodsCollectedStatus(itemId).catch(err => {
      console.log('查询商品收场状态失败', err);
    });
    simpleAlert(goodscollectedStatus ? '商品已收藏' : '商品未收藏');
  },
  /**
   * 跳转到淘宝商品页
   */
  async openDetail() {
    const itemId = '622499363381'; // iPad Pro 为例
    await openDetail(itemId).catch(err => {
      console.log('打开淘宝商品页失败', err);
    });
  },
  /**
   * 跳转到外部链接
   */
  navigateToOutside() {
    const url = 'https://www.tmall.com';
    navigateToOutside(url);
  },
  /**
   * 跳转到小程序内部链接（新开窗口）
   */
  navigateTo() {
    const url = '/pages/index/index';
    navigateTo(url);
  },
  /**
   * 跳转到小程序内部链接（不新开窗口）
   */
  redirectTo() {
    const url = '/pages/index/index';
    redirectTo(url);
  },
  /**
   * 选择上传图片
   */
  async uploadImage() {
    const uploadImageResultUrl = await uploadImage().catch(err => {
      commonToast(err && (err.errorMessage || '上传图片失败'));
    });
    if (uploadImageResultUrl) {
      this.setData({
        uploadImgUrl: uploadImageResultUrl
      });
    }
  },
  /**
   * 分享到群聊卡片
   */
  async chattingSendCard() {
    // 测试请求参数（格式示例）
    const requestInfo = {
      "biz_ext_map": "{\"activityId\":\"028fe748-9413-4df1-ad15-7d21d9ca16c9\",\"shareId\":\"AAGrFC1BALWl0Axwb3svqUyd\"}",
      "card_template_id": 1588754547060,
      "group_id": "0_G_2207623078795_1591670473134",
      "weex_data_json": "{\"url\":\"https://m.duanqu.com?_ariver_appid=3000000005188064&nbsv=0.1.2007151634.12&nbsource=debug&nbsn=DEBUG&_mp_code=tb&query=activityId%3D028fe748-9413-4df1-ad15-7d21d9ca16c9%26groupId%3D0_G_2207623078795_1591670473134%26shareId%3DAAGrFC1BALWl0Axwb3svqUyd\",\"act_title\":\"一起出道赢大奖\",\"share\":\"@pilee0827 多度\",\"picture3\":\"https://yun.duiba.com.cn/upload/ltuwhbf39x.jpg\"}",
      "message_id": "5f0fcdfeef507182be6c2247",
      "app_secret": "appSecret",
      "app_code": "30123678"
    };
    const messageResult = await chattingSendCard(requestInfo).catch(err => {
      commonToast(err && err.errorMessage);
    });
    if (messageResult) {
      const { result: { value, success } } = messageResult;
      commonToast(value && success ? '分享到群聊成功' : '分享到群聊失败');
    }
  },
  /**
   * 文本风险校验
   */
  async textRiskIdentification() {
    const { riskInput } = this.data;
    const success = await textRiskIdentification(riskInput).catch(err => {
      console.log(err);
    });
    simpleAlert(`检测文本"${riskInput}"，校验结果${success ? '通过' : '不通过'}`);
  },
  /**
   * 领取实物奖励
   */
  async receiveObjectPrize() {
    const _id = '123'; // 测试奖品ID
    const success = await API.fn.receiveObjectPrize({ _id });
    if (success) {
      commonToast('保存成功');
    }
  },
  /**
   * 领取权益奖励
   */
  async receiveEnamePrize() {
    const _id = '123'; // 测试奖品ID
    const success = await API.fn.receiveEnamePrize({ _id });
    if (success) {
      commonToast('领取成功');
    }
  },

  /**
   * 复制到剪切板
   */
  async setClipboard() {
    await setClipboard('text')
    commonToast('复制成功')
  },

  /**
   * 获取缓存数据
   */
  async getStorage() {
    let text = await getStorage('test')
    console.log(text)
    commonToast(text)
  },

  /**
   * 设置缓存数据
   */
  async setStorage() {
    await setStorage('test','test storage')
  },

  /**
   * 跳转店铺首页 shopId
   */
  async navigateToTaobaoPage() {
    await navigateToTaobaoPage()
  },
  async showSkuModal() {
    let result = await showSkuModal(String(615356100592))
    console.log(result)
  },
  async confirmCustomOrder() {
    console.log(confirmCustomOrder)
    await confirmCustomOrder(615356100592, 4337070448206)
  },
  async openMessage() {
    await openMessage()
  },
});
