/**
 * receiveType 1 点击领取关闭弹窗跳转我的奖品页面 2 点击领取直接领取奖励  3 领取跳转商品支付页面
 */
import API from '../../api';
import { SELLER_ID } from '../../constants';
const app = getApp();
const { tbccTs } = app;
const { navigateTo, openDetail, commonToast } = tbccTs.tb;
const { throttleHandle, checkMember } = tbccTs.utils;
//mock数据
const configPrize = {
  receiveType: 1,// receiveType 1 点击领取关闭弹窗跳转我的奖品页面 2 点击领取直接领取奖励  3 领取跳转商品支付页面
  prize: {
    image: 'https://img.alicdn.com/imgextra/i3/2374579403/O1CN011TUe7Y2JKcrllQt0c_!!2374579403-0-miniprogram.jpg',
    name: '测试奖品',
    id: '601bb55d8e6a085deb71bf65',
    itemId: 617724147979,
    type: 3
  }
}
Component({
  mixins: [],
  data: {
    memberShopVisible: false
  },
  props: {
    receiveType: configPrize.receiveType,
    prize: {}
  },
  didMount() {},
  didUpdate() {},
  didUnmount() {},
  methods: {
    onModalClose() {
      const { onModalClose, dataName } = this.props
      onModalClose && onModalClose(dataName)
    },
    handleConfirm: throttleHandle(async function() {
      const { activityId } = app
      const { prize: { image, id, type, itemId }, receiveType } = this.props
      // 未中奖
      if(!image) {
        this.onModalClose()
        return;
      }
      // 点击领取关闭弹窗跳转我的奖品页面
      if(receiveType === 1) {
        this.onModalClose()
        navigateTo('/pages/myprize/myprize')
        return;
      }
      // 领取跳转商品支付页面
      if(receiveType === 3) {
        this.onModalClose()
        openDetail(String(itemId))
        return;
      }

      // 点击领取直接领取奖励
      if(receiveType === 2) {
        const params = { activityId, id }
        if(type == 2) {
          this.receiveCreditPrize(params)
          return;
        }
        const success = type === 1 ? (await API.fn.receiveEnamePrize(params)) :
          type === 3 ? (await API.fn.receiveObjectPrize(params)) : false
        
        if(success) {
          commonToast('领取成功')
          this.onModalClose()
          return;
        }
        this.onModalClose()
      }
    },2000),

    // 领取积分
    async receiveCreditPrize() {
      const { activityId } = app
      const { prize: { id }, receiveType } = this.props
      // const isVip = await API.fn.getVipInfo({ activityId })
      const isMember = await checkMember(SELLER_ID)

      if(!isMember) {
        this.setData({ memberShopVisible: true })
        return;
      }

      const success = await API.fn.receiveEnamePrize({ activityId, id })
      if(success) {
        commonToast('领取成功')
        this.onModalClose()
        return;
      }
      this.onModalClose()
    },

    // 关闭入会组件
    closeCommonModal() {
      this.setData({ memberShopVisible: false })
    },
    // 入会成功
    onSuccess() {
      this.receiveCreditPrize()
      this.setData({ memberShopVisible: false })
    }
  },
});
