import { useEffect, useRef, useState } from 'react'
import Taro, { useDidShow, showToast } from '@tarojs/taro'
import { getSetting, openSetting, authorize, getAuthUserInfo } from 'tbcc-sdk-ts/lib/core/tb'
import { useThrottle } from '@/hooks/useThrottle'

// 授权
export function useAuth(authSuccess = () => {}) {
  const [visible, setVisible ] = useState(false)
  const goToOpenSetting = useRef(false)
  // 授权信息调用是否完成 防止用户调用了授权API 未弹出再次点击
  const completeHandle = useRef(true)
  // 获取授权信息
  const onHandleSetting = useThrottle(async () => {
    const res = await getSetting()
    if(!res.authSetting?.userInfo) {
      const authResult = await authorize().catch(err => {
        setVisible(true)
        showToast({ title: '请先授权，授权成功后才可参与活动' })
        completeHandle.current = true
      })
      if(authResult) {
        authUserInfo()
      }
    }else {
      authUserInfo()
    }
  })
  // 打开授权设置
  const onOpenSetting = useThrottle(async () => {
    if(!completeHandle.current) return;
    goToOpenSetting.current = true
    showToast({ title: '打开授权开关，授权成功后才可参与活动', duration: 1000, success: () => openSetting() })
  })
  // 获取用户授权信息
  const authUserInfo = async() => {
    completeHandle.current = true
    const info = await getAuthUserInfo()
    if (info) {
      authSuccess(info)
      setVisible && setVisible(false)
    }
  }
  useEffect(() => {
    onHandleSetting()
  }, [])

  useDidShow(() => {
    if(goToOpenSetting.current) {
      // 重新授权
      onHandleSetting()
      completeHandle.current = false
      goToOpenSetting.current = false
    }
  })

  return {
    visible,
    onHandleSetting,
    onOpenSetting
  }
}