// import {
//   Main,
//   GDispatcher
// } from '../../../utils/output.js';
/**
 * 直接取，app
 */
const app = getApp()
Component({
  isUpdateFlag: true,
  data: {},
  props: {
    data: {}
  },
  didMount(query) {},
  didUpdate() {},
  didUnmount() {
    // 页面被关闭
    this.main && this.main.destroy();
  },
  methods: {
    onCanvasReady() {
      console.log("进canvas了")
      // 创建Main，授权登录完后才创建
      const self = this;
      my.createCanvas({
        id: 'canvas',
        success: (ccc) => {
          // const dpr = my.getSystemInfoSync().pixelRatio
          // const windowWidth = my.getSystemInfoSync().windowWidth;
          // const windowHeight = my.getSystemInfoSync().windowHeight;
          // ccc.width = windowWidth * dpr + dpr; //重新修改会有误差
          // ccc.height = windowHeight * dpr + dpr;
          // console.log(Main)
          // console.log(ccc.width, ccc.height)
          if (!this.main) {
            try {
              this.main = new my.NewGame(ccc)
              my.GDispatcher.addEventListener("GameSceneReady", self.gameSceneReady, self)
              //添加事件，为了和main里的通信
              this.main.addGlobalEvent("onMessage", self.onMessage, self)
            } catch (err) {
              console.error(err)
            }
          }
        }
      })
    },
    gameSceneReady() {
      my.GDispatcher.dispatchEvent("GameStart")
    },
    //和main通信的方法，接收main的信息
    onMessage(e) {
      //接口名字
      let netName = e.data.netName;
      //接口参数
      let parameter = e.data.parameter;
      if (netName.indexOf("mine") == 0) {
        // 和游戏页面通信
        this.props.onMessage({
          type: 'message',
          target: {
            id: this.props.id
          },
          data: {
            netName,
            parameter,
            postMessage: (netName, data) => this.postMessage(netName, data)
          }
        })
      } else {
        this.postMessage(netName, {
          success: false
        })
      }
    },
    postMessage(netName, data) {
      this.main && this.main.dispatchGlobalEvent({
        type: netName
      }, data) //以防复用事件event串了，就用这种方式
    },
    //鼠标事件
    onMouseEvent(e) {
      if (this.main) this.main.stage.onMouseEvent(e)
    },
  }
});
