import { View, Image, Text } from '@tarojs/components'
import React from 'react'
import Modal from '@/components/_base/Modal/Modal'
import { useThrottle } from '@/hooks/useThrottle'
import classnames from 'classnames'
import styles from './ThanksModal.module.less'

const thanksConfig = {
  1: {
    title: '很遗憾,未抽中奖品\n再接再厉',
    btnTxt: '再抽一次',
    btnImg: '//yun.duiba.com.cn/taobaomini/pike_call/thanks_btn.png',
    icon: '//yun.duiba.com.cn/taobaomini/provideBeauty/close_btn.png',
    desc: '奖品可在我的奖品中查看'
  },
  2: {
    title: '很遗憾,未抽中奖品\n再接再厉',
    btnTxt: '再抽一次',
    icon: '//yun.duiba.com.cn/taobaomini/provideBeauty/close_btn.png',
    desc: '奖品可在我的奖品中查看'
  }
}
export default function ThanksModal(props) {
  const { onHandle = () => {}, onClose, type = 1, hasClose = false, hasDesc = false } = props
  
  const getContainerStyle = classnames(styles['thanks-container'],{
    [`${styles['thanks-container-02']}`]: type === 2
  })
  // 标题样式
  const getTitleStyle = classnames(styles['thanks-title'],{
    [`${styles['thanks-title-02']}`]: type === 2
  })
  // 按钮样式
  const getBtnStyle = classnames(styles['thanks-btn'],{
    [`${styles['thanks-btn-02']}`]: type === 2
  })
  const onCloseModal = () => {
    onClose && onClose()
  }
  return (
    <Modal hideCloseButton={false} onClose={onCloseModal} top={'50%'}>
      <View className={getContainerStyle}>
        <Text className={getTitleStyle}>{thanksConfig[type].title}</Text>
        <Image src={thanksConfig[type].btnImg} className={getBtnStyle} onClick={()=> onHandle(type)} />
        {hasDesc && <View className={styles['thanks-desc']}>{thanksConfig[type].desc}</View>}
      </View>
    </Modal>
  )
}