**记事本打开((cmd + k) + v)** 

##### 大转盘配置项入参

|    配置项    |   类型   |    描述     |  默认值  |  备注  |
| :--------   | :-----:  | :--------: | :-----:  | :---:|
| bg    |   String   |    转盘背景   |  /  | / |
| radius        |   Number   |  转盘半径大小   | 300 |  px  |
| ratio         |   Number   |  距离中心点的比例系数   | 0.65 |  小于1  |
| divideNum     |   Number   |    转盘划分为几等分   | 8 |  最少2等分|
| circles       |   Number   |  转盘基本转动圈数   |  4  |  /  |
| duration      |   Number   |  转盘持续时间   |  4000  |  毫秒  |
| timeFunction  |   String   |  缓动动画方式   |  'ease-out'  |  'ease-in-out', cubic-bezier(xx,xx,xx,xx)  |
| nodeInfo      |   Object   |  单个奖品区域大小   |  {width:100,height:100} |  宽高100px  |
| imgInfo      |   Object   |  奖品图片大小   |  {width:80,height:80} |  宽高80px  |
| showWay       |   String   |  奖品排列方式 |  'negative'  |negative逆时针排列 positive顺时针排列|
| isShowPrizeName      |   Boolean   |  是否展示奖品名称   |  true  |  true展示  false不展示  |
| prizeNameWidthRatio      |   Number   |  奖品名称容器宽度与nodeInfo宽度的比值  |  1.2  |  超过容器宽度则...省略 |

##### 出参
|    配置项    |   类型   |    描述     |  默认值  |  备注  |
| :--------   | :-----:  | :--------: | :-----:  | :---:|
| callback    |   Function   |    回调函数   |  /  |抽中奖品后的回调方法,后续的弹窗处理|

+ 使用
```jsx
import RotateWheel from '@/components/_tb_comps/RotateWheel/RotateWheel'

const rotateConfig = {  //不传走默认配置
  bg: 'https://yun.duiba.com.cn/spark/assets/8b6e920ffd09fab8f9ac2de09f9154879f4d0607.png',
  ratio: 0.65,
  radius: 300,
  circles: 4,
  divideNum: 8,
  duration: 5000,
  timeFunction:'ease-out',
  nodeInfo:{
      width:100,
      height:100
  },
  imgInfo:{
      width:80,
      height:80
  },
  showWay:'negative',//positive/negative
  isShowPrizeName:true
}

export const Index = () => {
    return(
        <RotateWheel {...rotateConfig} callback={()=>{}} />
    )
}

```