import { useState } from 'react'
import { createModel } from 'hox'
import { ACTIVITY_STATUS } from '../const'

function useActivityInfo() {
  const [ activityInfo, setActivityInfo ] = useState({
    _id: '',
    title: '',
    startTime: 0,
    endTime: 0,
    rule: '',
    activityStatus: ACTIVITY_STATUS.NO_EXIST
  })

  /**
   *
   *  获取活动状态
   *
   * @param {*} acInfo 活动信息
   * @return {*}  活动状态
   */
  const getActivityStatus = acInfo => {
    const { startTime, endTime } = acInfo
    const now = Date.now()
    const noStart = startTime > now
    const isEnd = endTime < now
    if (startTime === 0 && endTime === 0) return ACTIVITY_STATUS.NO_EXIST
    if (noStart) return ACTIVITY_STATUS.NO_START
    if (isEnd) return ACTIVITY_STATUS.END
    return ACTIVITY_STATUS.PROCESSING
  }

  const setActivityInfoAndStatus = acInfo => {
    const activityStatus = getActivityStatus(acInfo)

    setActivityInfo({
      ...acInfo,
      activityStatus
    })
  }

  return {
    activityInfo,
    setActivityInfoAndStatus
  }
}

export const useActivityInfoModel = createModel(useActivityInfo)
