import { View, ScrollView, Image } from '@tarojs/components'
import React, { useState, useRef } from 'react'
import { noopFn } from '@/utils/util'
import Popup from '@/components/_base/Popup/Popup'
import styles from './TasksModal.module.less'
import { useTasks } from '@/hooks/useTasks'
import { TASK_CONFIG, TASK_STATUS } from '@/config/task.config'

const { icons, commonTxt, doTxt, rewardMsg } = TASK_CONFIG

export default function TasksModal(props) {
  const { onClose = noopFn } = props
  const [ memberShopVisible, setMemberShopVisible ] = useState(false)
  const { taskList, handleItem, fetchTaskList } = useTasks(props)
  const checkItem = useRef(null)

  const handleTask = (itm) => {
    checkItem.current = itm
    handleItem(itm,() => {
      setMemberShopVisible(true)
    })
  }
  const onCloseMemberModal = () => {
    setMemberShopVisible(false)
  }
  const onAuthSuccess = () => {
    setMemberShopVisible(false)
    checkItem.current && handleItem(checkItem.current)
  }
  const onAuthFail = () => {
    setMemberShopVisible(false)
  }
  const onCloseModal = () => {
    onClose && onClose()
  }
  return (
    <>
      <Popup onClose={onCloseModal} height='700rpx'>
        <View className={styles['modal-container']}>
          <View className={styles['modal-content']}>
            <View className={styles['modal-content__title']}>任务模块</View>
            <View className={styles['modal-content__list']}>
              <ScrollView scroll-y='{{true}}' className={styles['modal-content__scroll']}>
                {
                taskList.map((item, i) => {
                  return (
                    <View className={styles['item']} key={'task_I' + i}>
                      <View className={styles['item__left']}>
                        <Image src={icons[item.key]} mode='widthFix' />
                      </View>
                      <View className={styles['item__left-label']}>
                        <View className={styles['item__left-title']}>{item.name}</View>
                        <View className={styles['item__left-reward']}>{rewardMsg + item.reward}</View>
                      </View>
                      <View className={`${styles['list-item__right']} ${styles['item__status-' + item.status]}`} onClick={() => handleTask(item)}>
                        {
                          item.status === TASK_STATUS.WAIT_DO ? (doTxt[item.key] || '去完成') : commonTxt[item.status]
                        }
                      </View>
                    </View>
                  )
                })
              }
              </ScrollView>
            </View>
          </View>
        </View>
      </Popup>
      {<member-modal expend={memberShopVisible} onClose={onCloseMemberModal} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
    </>
  )
}
