/**
 * 时间格式化
 * @param date    接收可以被new Date()方法转换的内容
 * @param format  字符串，需要的格式例如：'yyyy/MM/dd hh:mm:ss'
 * @returns {String}
 */
export declare const dateFormatter: (dateTxt: string, format?: string) => string;
/**
 * 版本比较
 * @param {string} cur 当前版本
 * @param {string} compare 比较版本
 */
export declare const versionCompare: (cur: string, compare: string) => boolean;
/**
 * 获取request请求所需参数
 * @param {object/string} value API项配置
 */
export declare const getRequestParams: (value: any) => {
    handle: string;
    method: string;
    ext: {};
    defaultParams?: undefined;
} | {
    handle: any;
    method: any;
    defaultParams: any;
    ext: any;
};
/**
 * 生成API
 * @param {array} apiList API数据数组
 * @param {function} request 请求
 */
export declare const generateAPI: (apiList: any, request: any) => {};
/**
 * 函数节流，普通防连点
 * @param {fun} fun 函数
 * @param {delay} delay 时间
 */
export declare const throttleHandle: (fun: (t: any) => any, delay?: number) => () => void;
/**
 * 根据fileId获取图片地址
 * @param fileId
 */
export declare const getImgShareUrl: (fileId: string | Array<string>) => Promise<any>;
/**
 * 根据sellerId判断入会状态
 * @param sellerId
 */
export declare const checkMember: (sellerId: number) => Promise<unknown>;
/**
 * 毫秒转换成00:00:00格式
 * @param ms 毫秒
 */
export declare const formatTimeStamp: (ms: number) => string;
/**
 * 活动状态验证
 * @param startTime
 * @param endTime
 * @param noCheck
 */
export declare const validateActivityStatus: (startTime: number, endTime: number, noCheck: boolean) => Promise<unknown>;
