"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var requestFn_1 = require("../helpers/requestFn");
var helpers_1 = require("../helpers");
/**
 * 接口请求封装
 * @param { cloud, cloudName, requestType, mockUrl }
 */
var request = function (header) {
    var cloud = header.cloud, cloudName = header.cloudName, _a = header.requestType, requestType = _a === void 0 ? 'cloud' : _a, mockUrl = header.mockUrl;
    if (!cloud) {
        console.error('请传入cloud');
        return false;
    }
    if (!cloudName) {
        console.error('请传入云函数名称');
        return false;
    }
    return function (handle, method, params, ext) {
        if (method === void 0) { method = 'POST'; }
        return __awaiter(void 0, void 0, void 0, function () {
            var _a, activityId, tornadoAPI, _b, nickName, _cloudName, _c, isShowLoading, mockUrlPrefix, reqConfig, initConfig, params_;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _a = getApp(), activityId = _a.activityId, tornadoAPI = _a.tornadoAPI, _b = _a.nickName, nickName = _b === void 0 ? '' : _b;
                        _cloudName = ext.cloudName || cloudName;
                        _c = ext.isShowLoading, isShowLoading = _c === void 0 ? false : _c;
                        mockUrlPrefix = {
                            ams: 'https://ams.dui88.com/server/index.php?g=Web&c=Mock&o=simple&projectID=218&uri=',
                            yapi: 'https://docs.dui88.com/mock/140/'
                        };
                        reqConfig = { cloudName: _cloudName, handle: handle, method: method, isShowLoading: isShowLoading };
                        initConfig = { requestType: requestType, tornadoAPI: tornadoAPI, nickName: nickName, mockUrlPrefix: mockUrlPrefix, mockUrl: mockUrl };
                        params_ = __assign({ activityId: activityId }, params);
                        if (!['ams', 'yapi', 'tornadoAPI'].includes(requestType)) return [3 /*break*/, 2];
                        return [4 /*yield*/, requestFn_1.requestMock(reqConfig, initConfig, params_)];
                    case 1: return [2 /*return*/, _d.sent()];
                    case 2: return [4 /*yield*/, helpers_1.cloudRequest(cloud, _cloudName, handle, params_, isShowLoading)];
                    case 3: return [2 /*return*/, _d.sent()];
                }
            });
        });
    };
};
exports.default = request;
//# sourceMappingURL=index.js.map