"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloudRequest = exports.myRequest = exports.isLoading = exports.strategyEname = exports.getTmallMemberStatus = exports.AudioModel = exports.promisifyApiToTb = exports.confirmPromisifyApi = exports.promisifyApi = exports.promisifyApiSimple = void 0;
/**
 * 简易API封装
 * @param methodName
 * @param params
 * @param name
 */
exports.promisifyApiSimple = function (methodName, params, name) {
    if (name) {
        // @ts-ignore
        my[methodName](name, params);
        return;
    }
    // @ts-ignore
    my[methodName](params);
};
/**
 * 通用API封装
 * @param methodName
 * @param params
 */
exports.promisifyApi = function (methodName, params) {
    if (params === void 0) { params = {}; }
    return new Promise(function (resolve, reject) {
        // @ts-ignore
        my[methodName](__assign(__assign({}, params), { success: function (res) {
                resolve(res);
            }, fail: function (err) {
                reject(err);
            } }));
    });
};
/**
 * 通用API封装
 * @param methodName
 * @param params
 */
exports.confirmPromisifyApi = function (title, content, successCb) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                my.confirm({
                    title: title,
                    content: content,
                    confirmButtonText: '确定',
                    cancelButtonText: '取消',
                    success: function (result) { return __awaiter(void 0, void 0, void 0, function () {
                        var confirm, cbResult;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    confirm = result.confirm;
                                    if (!(confirm && successCb)) return [3 /*break*/, 2];
                                    return [4 /*yield*/, successCb()];
                                case 1:
                                    cbResult = _a.sent();
                                    resolve(cbResult);
                                    _a.label = 2;
                                case 2:
                                    resolve(false);
                                    return [2 /*return*/];
                            }
                        });
                    }); },
                });
            })];
    });
}); };
/**
 * 通用API封装
 * @param methodName
 * @param params
 */
exports.promisifyApiToTb = function (methodName, params) {
    if (params === void 0) { params = {}; }
    return new Promise(function (resolve, reject) {
        // @ts-ignore
        my.tb[methodName](__assign(__assign({}, params), { success: function (res) {
                resolve(res);
            }, fail: function (err) {
                reject(err);
            } }));
    });
};
/**
 * 创建音频类
 */
var AudioModel = /** @class */ (function () {
    function AudioModel(opts) {
        var src = opts.src;
        if (!src) {
            console.error('请输入音频链接');
            return false;
        }
        try {
            // @ts-ignore
            var innerAudioContext_1 = my.createInnerAudioContext();
            Object.keys(opts).forEach(function (item) {
                innerAudioContext_1[item] = opts[item];
            });
            return innerAudioContext_1;
        }
        catch (e) {
            console.error('当前版本不支持音频');
        }
    }
    return AudioModel;
}());
exports.AudioModel = AudioModel;
/**
 * 获取天猫会员状态
 */
exports.getTmallMemberStatus = function () { return __awaiter(void 0, void 0, void 0, function () {
    var cloud;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                cloud = app.cloud;
                return [4 /*yield*/, cloud.topApi.invoke({
                        api: "tmall.campus.industry.app.audit.query",
                        data: {
                            source: "duibajk",
                        },
                    }).catch(function (err) {
                        console.log(err);
                    })];
            case 1: return [2 /*return*/, (_a.sent()) || {}];
        }
    });
}); };
/**
 * 拉菲奖品发放
 * @param params
 */
exports.strategyEname = function (params) { return __awaiter(void 0, void 0, void 0, function () {
    var cloud;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                cloud = app.cloud;
                return [4 /*yield*/, cloud.topApi.invoke({
                        api: "alibaba.latour.strategy.issue",
                        data: {
                            channel: params.channel || "",
                            strategy_code: params.strategyCode || "",
                            selected_benefit_code: params.code || "",
                        },
                    }).catch(function (err) {
                        console.log("err", err);
                    })];
            case 1: return [2 /*return*/, (_a.sent()) || {}];
        }
    });
}); };
/**
 * loading
 * @param methodName
 * @param params
 * @param name
 */
exports.isLoading = function (methodName) {
    // @ts-ignore
    my[methodName]();
};
/**
 * 数据请求
 * @param params
 * @param loading
 */
exports.myRequest = function (params, handle, loading) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                my.request(params).then(function (_a) {
                    var res = _a.data;
                    console.log("\u8C03\u7528" + handle + "\u63A5\u53E3\u8FD4\u56DE\u7ED3\u679C", res);
                    loading && exports.isLoading('hideLoading');
                    if (res && res.success) {
                        resolve(res);
                    }
                    else {
                        reject(res);
                    }
                }).catch(function (e) {
                    loading && exports.isLoading('hideLoading');
                    console.log(e);
                    reject();
                });
            })];
    });
}); };
/**
 * 云函数接口请求
 * @param _cloudName
 * @param handle
 * @param params
 * @param loading
 */
exports.cloudRequest = function (cloud, _cloudName, handle, params, loading) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, new Promise(function (resolve, reject) {
                // @ts-ignore
                cloud.function.invoke(_cloudName, params, handle).then(function (res) {
                    console.log("\u8C03\u7528" + handle + "\u63A5\u53E3\u8FD4\u56DE\u7ED3\u679C", res);
                    loading && exports.isLoading('hideLoading');
                    if (res && res.success) {
                        resolve(res);
                    }
                    else {
                        reject(res);
                    }
                    return res;
                }).catch(function () {
                    loading && exports.isLoading('hideLoading');
                    reject();
                });
            })];
    });
}); };
//# sourceMappingURL=index.js.map