/** @format */

import { getToday } from './getToday'
/**
 * 判断是否新会员
 *
 * @format
 * @param {IUserInfo} userInfo
 * @param {IVipInfo} vipInfo
 * @returns {boolean}
 * @memberof UserService
 */

export function isNewVip(userInfo: IUserInfo, vipInfo: IVipInfo): boolean {
  const {
    member: { flag }
  } = userInfo

  const { isVip } = vipInfo

  return !flag && isVip && !userInfo.member.newMember
}

export function setNewVipUserData(member: IMemberInfo): IMemberInfo {
  const today = getToday()
  return {
    ...member,
    newMember: true,
    bememberTime: Date.now(),
    bememberDay: today
  }
}

export function setNewFollowUserData(follow: IFollowInfo): IFollowInfo {
  const followBefore = follow.flag
  const today = getToday()
  if (followBefore || follow.newFollow) {
    return follow
  }
  return {
    ...follow,
    newFollow: true,
    followTime: Date.now(),
    followDay: today
  }
}
