import API from "/api";
Component({
  mixins: [],
  data: {
    dialogTop: "",
    chooseArr: [],
    chooseId: [],
    firstGetList: false,
    searchInfo: {
      approveStatus: "onsale",
      title: "",
      pageNo: 1,
      pageSize: 8,
    },
    babyDialogInfo: {
      list: [],
      pageNo: 1,
      pageSize: 8,
      totalCount: "",
      totalPages: 0,
    },
  },
  props: {
    onClose: () => { },
    showBaby: false,
    limit: 20,
    browseItemIds: "",
    onUpdateBabyChoose: () => { },
  },
  didMount() {
    this.initPosition();
    const { searchInfo } = this.data;
    this.getBabyList(searchInfo);
  },
  didUnmount() { },
  methods: {
    initPosition() {
      const { scrollTop } = this.$page.data;
      this.setData({
        dialogTop: scrollTop * 2,
      });
    },
    getBabyList(info, chooseId) {
      console.log(info);
      API.findItemListByStatus({
        ...info,
      }).then((res) => {
        if (res.success) {
          const { browseItemIds } = this.props;
          console.log(`534543`, {
              ...this.data.babyDialogInfo,
              ...res.data,
              list: res.data.list ? res.data.list : [],
            });
          this.setData({
            chooseId: chooseId
              ? [...chooseId]
              : browseItemIds
                ? browseItemIds.split(",").map((i) => +i)
                : [],
            babyDialogInfo: {
              ...this.data.babyDialogInfo,
              ...res.data,
              list: res.data.list ? res.data.list : [],
            },
          });
        }
      });
    },
    getHasChooseBaby(itemIds) {
      if (itemIds) {
        API.findItemListByIds({ itemIds })
          .then((res) => {
            if (res.success) {
              this.setData({
                chooseArr: res.data.list,
              });
            } else {
              my.showToast({
                type: "fail",
                content: res.message,
              });
            }
          })
          .catch((err) => {
            console.log(err);
          });
      }
    },
    changeTableItem(e) {
      const { value } = e.detail;
      const { chooseId } = this.data;

      if (value === ".$choose") {
        if (!chooseId.length) {
          this.setData({
            chooseArr: [],
          });
        } else {
          let itemIds = chooseId.join(",");
          this.getHasChooseBaby(itemIds);
        }
      }
    },
    searchBabyList() {
      this.setData({
        searchInfo: {
          ...this.data.searchInfo,
          pageNo: 1,
        },
      });
      this.getBabyList(this.data.searchInfo, this.data.chooseId);
    },
    changePagination(e) {
      this.setData({
        searchInfo: {
          ...this.data.searchInfo,
          pageNo: e.detail.value,
        },
      });
      this.getBabyList(this.data.searchInfo, this.data.chooseId);
    },
    closeBaby() {
      this.props.onClose("baby");
    },
    changeCheckStatus(e) {
      const { chooseId } = this.data;
      const { limit } = this.props;
      const { item } = e.target.dataset;
      if (chooseId.includes(item.itemId)) {
        this.setData({
          chooseId: chooseId.filter(v => v !== item.itemId),
        });
      } else {
        if (chooseId.length >= +limit) {
          my.showToast({
            type: "fail",
            content: `最多选择${limit}个宝贝`,
          });
          return;
        }
        this.setData({
          chooseId: [...chooseId, item.itemId],
        });
      }
    },
    sureBabyDialog() {
      const { chooseId } = this.data;
      // console.log(chooseId, "chooseId");
      this.props.onUpdateBabyChoose(chooseId.join());
      this.closeBaby();
    },
    changeSearchKeyWords(e) {
      this.setData({
        searchInfo: {
          ...this.data.searchInfo,
          title: e.detail.value,
        },
      });
    },
    changeStatus(e) {
      this.setData({
        searchInfo: {
          ...this.data.searchInfo,
          approveStatus: e.detail.value,
        },
      });
    },
    changeNoCheckBaby(e) {
      const { chooseId } = this.data;
      const { item } = e.target.dataset;
      this.setData(
        {
          chooseId: chooseId.filter((i) => {
            return i !== item.itemId;
          }),
        },
        () => {
          this.getHasChooseBaby(this.data.chooseId.join(","));
        }
      );
    },
  },
});
