/** @format */

import { CODE_TYPES } from './../constants'
import { services, paramsCheck } from '../decorator'

import { resultsModel } from '../sdk'
import { TaobaoTopService } from '../service'
export default class BaseController {
  /**
   *  通过状态获取top商品列表
   */
  @paramsCheck(['approveStatus', 'title', 'pageNo', 'pageSize'])
  @services([TaobaoTopService])
  async findItemListByStatus(context: Context, { session }, [taobaoTopService]: [TaobaoTopService]) {
    const { approveStatus = 'onsale', title = '', pageNo = 1, pageSize = 10 } = context.data
    let result = await taobaoTopService.getItemListByStatus(session, {
      approveStatus,
      title,
      pageNo,
      pageSize
    })
    return result
  }

  /**
   *  通过状态获取top商品列表
   */
  @paramsCheck(['itemIds'])
  @services([TaobaoTopService])
  async findItemListByIds(context: Context, { session }, [taobaoTopService]: [TaobaoTopService]) {
    const { itemIds } = context.data
    return await taobaoTopService.getItemListByIds(itemIds, session)
  }

  /**
   *  通过ename获取权益信息
   */
  @paramsCheck(['ename'])
  @services([TaobaoTopService])
  async queryBenefitByEname(context: Context, { session }, [taobaoTopService]: [TaobaoTopService]) {
    const { ename } = context.data
    return await taobaoTopService.getPrizeByEname(session, ename)
  }
}
