import { View, ScrollView, Text } from '@tarojs/components'
import React from 'react'
import Modal from '@/components/_base/Modal/Modal'

import styles from './RuleModal.module.less'

export default function RuleModal(props) {
  const { bg = '', width = 300, height = 300, rule = '', onClose, closePostion, top = '40%' } = props
  return (
    <Modal onClose={onClose} closePostion={closePostion} top={top}>
      <View className={styles.content} style={{ width: `${width / 100}rem`, height: `${height / 100}rem`, backgroundImage: `url(${bg})` }}>
        <View className={styles.title}>活动规则</View>
        <ScrollView className={styles.scroll} scrollY>
          <Text className={styles.rule}>{rule}</Text>
        </ScrollView>
      </View>
    </Modal>
  )
}
