import React ,{ memo } from 'react'
import { View, Image, ScrollView } from '@tarojs/components'
import { RANK_LIST } from '@/mock'
import styles from './RankList.module.less'

const RANK_ICON = {
  1: '//yun.duiba.com.cn/taobaomini/pike_call/icon_06.png',
  2: '//yun.duiba.com.cn/taobaomini/pike_call/icon_07.png',
  3: '//yun.duiba.com.cn/taobaomini/pike_call/icon_08.png'
}
const RankList = memo((props) => {
  const { rankList = RANK_LIST, rankIcon = RANK_ICON } = props
  return (
    <ScrollView scrollY className={styles['scroll-container']}>
      {rankList.map((itm, i) => {
        return (
          <View
            className={`${styles['scroll-item']} ${
              styles['scroll-item' + (i + 1)]
            }`}
          >
            <View className={styles['scroll-item__rank']}>
              {i <= 2 && (
                <Image className={styles['rank-icon']} src={rankIcon[i + 1]} />
              )}
              <View className={styles['rank-num']}>{itm.rank}</View>
            </View>
            <View className={styles['scroll-item__user']}>{itm.userNick}</View>
            <View className={styles['scroll-item__score']}>
              {itm.rankValue}
            </View>
          </View>
        )
      })}
    </ScrollView>
  )
}) 
export default RankList
