/** @format */

// 获取随机数
export const rand = (function () {
  let seed = new Date().getTime()
  function r() {
    seed = (seed * 9301 + 49297) % 233280
    return seed / 233280.0
  }
  return function (number: number) {
    return Math.ceil(r() * number)
  }
})()

export const signFigures = function (num: number, rank = 6) {
  if (!num) return 0
  const sign = num / Math.abs(num)
  const number = num * sign
  const temp = rank - 1 - Math.floor(Math.log10(number))
  let ans
  if (temp > 0) {
    ans = parseFloat(number.toFixed(temp))
  } else if (temp < 0) {
    ans = Math.round(number / Math.pow(10, temp)) * temp
  } else {
    ans = Math.round(number)
  }
  return ans * sign
}
