/** @format */

import { CARD_PRIZE_STATUS } from '../../constants'

export function setCardPrizeStatus(
  joinedTimes: number,
  needTimes: number,
  needKey: string,
  joinedTimesAwardList: IAwards[]
) {
  if (joinedTimes < needTimes) return CARD_PRIZE_STATUS.LOCK

  if (joinedTimes >= needTimes && !joinedTimesAwardList.some(v => v[needKey] === needTimes))
    return CARD_PRIZE_STATUS.UN_LOCK

  if (joinedTimes >= needTimes && joinedTimesAwardList.some(v => v[needKey] === needTimes))
    return CARD_PRIZE_STATUS.SUCCESS
}
