/** @format */
import { getToday } from '../getToday'

// login接口使用 当天第一次登陆有数据变更的时候使用
// updateFirstLoginToday({ $inc: { gameTime: 3}})
export default function updateUserInfo(update?: IPreUpdateQuery) {
  return async function (
    context: IContext<IParams>,
    { userInfo }: IControllerInfos
  ): Promise<IPreUpdateQuery | undefined> {
    if (!userInfo) return {}
    return update
  }
}

export function reduceGameTimes(needGameTimes: number) {
  return updateUserInfo({
    $where: `this.gameTimes >= ${needGameTimes}`,
    $inc: { gameTimes: -needGameTimes }
  })
}

export async function updateDrawRecord(
  context: IContext<IParams>,
  { userInfo }: IControllerInfos
): Promise<IPreUpdateQuery | undefined> {
  if (!userInfo) return {}
  return {
    $inc: {
      [`drawInfo.${getToday()}`]: 1
    }
  }
}

export function reduceCardGameTimes(needGameTimes: number) {
  return async function (
    context: IContext<IParams>,
    { userInfo }: IControllerInfos
  ): Promise<IPreUpdateQuery | undefined> {
    if (!userInfo) return {}
    let projection: IPreUpdateQuery = { $inc: {} }
    const today = getToday()
    const { gameTimes, gameTimesEveryday } = userInfo

    if (gameTimesEveryday?.[today]) {
      projection.$inc[`gameTimesEveryday.${today}`] = -needGameTimes
      projection.$where = `this.gameTimesEveryday["${today}"] >= ${needGameTimes}`
      return projection
    }

    if (gameTimes) {
      projection.$inc[`gameTimes`] = -needGameTimes
      projection.$where = `this.gameTimes >= ${needGameTimes}`
      return projection
    }
  }
}

export async function updateHelpRecord(
  context: IContext<IParams>,
  { userInfo }: IControllerInfos
): Promise<IPreUpdateQuery | undefined> {
  const { inviteId } = context.data
  if (inviteId) return {}
  if (!userInfo) return {}
  return {
    $set: {
      inviteId
    }
  }
}
