/** @format */
import { getToday } from '../getToday'
import { getTotalCompleteTask, getTodayCompleteTask } from '../task'
import { STAT_TYPE, TASK_RATE_TYPE } from '../../../constants'
import { getUserOrderlist } from '../getUserOrderlist'
import { CommonTaskService } from '../../../service/common'

export default function updateTaobaoGoods(taskType: ITaskType) {
  return async function (
    context: IContext<IParams>,
    { userInfo, activityInfo, taobaoOrderist }: IControllerInfos,
    [taskService]: [CommonTaskService]
  ): Promise<IPreUpdateQuery> {
    // const taskType = 'orderGoods'
    const { value, itemIds, taskRateType, times } = activityInfo?.tasks?.[taskType] || {}
    const { completeTimes, taskInfo } = getTotalCompleteTask(taskType, userInfo)
    const { todayCompleteTimes } = getTodayCompleteTask(taskType, userInfo)

    if (!activityInfo?.tasks?.[taskType]) return {}
    // 永久任务且已完成
    if (taskRateType === TASK_RATE_TYPE.FOREVER && completeTimes) {
      return {}
    }

    // 每日限制完成且完成次数达到限制
    const today = getToday()
    if (taskRateType === TASK_RATE_TYPE.EVERYDAY && todayCompleteTimes >= times) {
      return {}
    }

    // const orderResult = await getUserOrderlist(
    //   this.context,
    //   //@ts-ignore
    //   userInfo.createTime || activityInfo?.startTime || Date.now(),
    //   Date.now()
    // )

    const itemIdsArr = itemIds?.split(',')?.map(v => +v)

    let projection = {
      $inc: {
        [`remainTimes.${taskType}`]: 0
      },
      $set: {}
    }

    let targetOrders = userInfo?.taskInfo?.[today]?.[taskType] || []
    taobaoOrderist?.forEach(v => {
      // @ts-ignore
      // 商品订单包含目标商品 且orderId为新订单 或者不配置商品
      if ((itemIdsArr.includes(v.itemId) || !itemIds) && !taskInfo.some(order => order.orderId === v.orderId)) {
        if (taskRateType === TASK_RATE_TYPE.EVERYDAY && targetOrders.length >= times) {
          return
        }
        projection.$inc[`remainTimes.${taskType}`] += +value
        targetOrders.push({
          itemId: v.itemId,
          orderId: v.orderId,
          payTime: v.payTime,
          tId: v.tId,
          createTime: Date.now()
        })
        taskService.addStat(STAT_TYPE.ORDER_RECORD, userInfo, {
          itemId: v.itemId,
          orderId: v.orderId,
          payTime: v.payTime,
          tId: v.tId
        })
      }
      if (targetOrders?.length) {
        projection.$set[`taskInfo.${today}.${taskType}`] = targetOrders
      }
    })

    return projection
  }
}
