/** @format */

import { getToday } from '../getToday'
import { getTodayCompleteTask } from '../task'

export default async function updateSignTask(
  context: IContext<IParams>,
  { userInfo, activityInfo }: IControllerInfos
): Promise<IPreUpdateQuery | undefined> {
  if (!activityInfo?.tasks?.sign) return
  // 获取签到奖励
  const { value } = activityInfo?.tasks?.sign || {}

  const { todayCompleteTimes } = getTodayCompleteTask('sign', userInfo)
  const today = getToday()

  // 今天没有有完成记录
  return todayCompleteTimes === 0
    ? {
        $inc: {
          'remainTimes.sign': value || 0
        },
        $push: {
          [`taskInfo.${today}.sign`]: { createTime: Date.now() }
        }
      }
    : {}
}
