/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { formatVipCbUrl, getShopVip } from '../vip'
import { JOIN_LIMIT } from '../../../constants'

export default async function checkVip(context: IContext<IParams>, { vipInfo, activityInfo }: IControllerInfos) {
  if (!vipInfo) {
    vipInfo = await getShopVip(context, activityInfo, formatVipCbUrl(context))
  }
  const {
    collectCardConfig: { joinLimit }
  } = activityInfo

  if (joinLimit === JOIN_LIMIT.NO_LIMIT) return { vipInfo }
  if (!vipInfo?.isVip) return resultsModel.error(CODE_TYPES.ERROR_NO_VIP, '非店铺会员', vipInfo)

  return { vipInfo }
}
