/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { DRAW_STATUS, PRIZE_DATA_TYPE, PRIZE_TYPE } from '../../../constants'
import { dbFindOne } from '../mongodb'
import { AWARDS_DB_NAME } from '../../../db'

export default function checkValidPrize(prizeTypes: number[]) {
  return async (context: IContext<{ id: string }>, { activityInfo }: IControllerInfos) => {
    const { id } = context.data
    let awardInfo = await dbFindOne<IAwards>(context, AWARDS_DB_NAME, {
      _id: id
    })
    console.log(`receive-award`, awardInfo)
    // 奖品不存在
    if (!awardInfo) {
      return resultsModel.error(CODE_TYPES.ERROR_NO_PRIZE)
    }
    // 不是校验的奖品类型，非法操作
    if (!prizeTypes.includes(awardInfo.type)) {
      return resultsModel.error(CODE_TYPES.ERROR_FORBIDDEN_OPE)
    }

    // 状态不是1,6
    if (![DRAW_STATUS.WAITAWARD, DRAW_STATUS.RETRY].includes(awardInfo.drawStatus)) {
      return CODE_TYPES.ERROR_FORBIDDEN_OPE
    }

    return {
      awardInfo
    }
  }
}

export const checkValidObjectPrize = checkValidPrize([PRIZE_TYPE.OBJECT])

export const checkValidEnamePrize = checkValidPrize([PRIZE_TYPE.ENAME, PRIZE_TYPE.CREDITS])

export const checkCardPrize = async (context: IContext<IParams>, { userInfo }: IControllerInfos) => {
  const { prizeDataType, activityId, needTimes, needCards } = context.data
  const { openId } = context

  const { cardInfo, joinedTimes } = userInfo

  // // 已收集卡片的总数量
  // const cardQuantityCollectedCount = Object.values(cardInfo).reduce((total, count) => total + count, 0)
  // 已收集卡片类型
  const cardTypeCollectedCount = Object.keys(cardInfo).length

  if (prizeDataType === PRIZE_DATA_TYPE.CARD_TYPE_AWARD && cardTypeCollectedCount < needCards)
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '不满足抽奖条件')

  if (prizeDataType === PRIZE_DATA_TYPE.JOIN_TIMES && joinedTimes < needTimes)
    return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '不满足抽奖条件')

  let awardInfo = await dbFindOne<IAwards>(context, AWARDS_DB_NAME, {
    prizeDataType,
    activityId,
    openId,
    needTimes,
    needCards
  })
  if (awardInfo) return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '您已经领取过该奖品了~')
}
