/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { dbFindOne } from '../mongodb'
import { GITFT_CARD_DB_NAME } from '../../../db'
import { CommonCardService } from '../../../service/common'
import { STAT_TYPE } from '../../../constants'
import { userInfo } from 'os'

export default async function checkInviteUserCard(
  context: IContext<{ type: number; activityId: string; inviteId: string; giftId: string }>,
  { userInfo }: IControllerInfos,
  [cardService]: [CommonCardService],
  { inviteUserInfo }: IPreCheckData
): Promise<IPreCheckResult> {
  const { type, giftId } = context.data

  if (!inviteUserInfo) {
    console.error(`checkInviteUserCard必须搭配 checkInviteId使用`)
  }

  cardService.addStat(STAT_TYPE.ACCESS_FROM_GIFT_CARD, userInfo)

  const giftRecord = await dbFindOne<IGiftCardRecord>(context, GITFT_CARD_DB_NAME, {
    _id: giftId
  })
  if (!giftRecord) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '该邀请信息错误~')

  if (giftRecord.received) return resultsModel.error(CODE_TYPES.ERROR_CARD_NOT_ENOUGH, '该卡片已被收取~')

  const { cardInfo = {} } = inviteUserInfo
  if (cardInfo?.[type] <= 1 || !cardInfo?.[type])
    return resultsModel.error(CODE_TYPES.ERROR_CARD_NOT_ENOUGH, '邀请者该卡片不足')

  return {
    giftRecord
  }
}
