/** @format */

interface IBaseDao {
  dbName: string
  db: object
  constructor(context: any, dbName: string): any
  /**
   * 查询一条数据
   * @param query
   * @param projection
   */
  findOne<T>(query: object, projection?: IFindProjection): Promise<T | undefined>
  /**
   * 查询多条数据
   * @param query
   * @param projection
   */
  find<T>(query: object, projection?: IFindProjection): Promise<T[]>
  /**
   * 插入单条数据
   * @param document
   */
  insertOne<T>(document: T): Promise<string>
  /**
   * 插入多条数据
   * @param documents 插入对象
   */
  insertMany(documents: object[]): Promise<string[]>
  /**
   * 更新数据
   * @param query
   * @param options
   */
  update(query: object, options?: IUpdateQuery): Promise<number>
  /**
   * 删除多条数据
   * @param filter
   */
  delete(filter: object): Promise<any>
  /**
   * 获取条目数
   * @param query
   * @param options
   */
  count(query: IMongoQuery, options?: object): Promise<number>
  /**
   * 聚合查询
   * @param query
   * @param options
   */
  aggregate(pipeline: object | object[], options?: object): Promise<any>
}

interface IMongoQuery {
  [params: string]: string | boolean | number | IQuerySelector
}

interface IQuerySelector {
  // Comparison
  $eq?: any
  $gt?: any
  $gte?: any
  $in?: any[]
  $lt?: any
  $lte?: any
  $ne?: any
  $nin?: any[]
  // Logical
  $not?: any
  // Element
  /**
   * When `true`, `$exists` matches the documents that contain the field,
   * including documents where the field value is null.
   */
  $exists?: boolean
  $type?: any
  // Evaluation
  $expr?: any
  $jsonSchema?: any
  $mod?: any
  $regex?: RegExp | string
  $options?: string
  // Geospatial
  // TODO: define better types for geo queries
  $geoIntersects?: { $geometry: object }
  $geoWithin?: { [key: string]: any }
  $near?: { [key: string]: any }
  $nearSphere?: { [key: string]: any }
  $maxDistance?: number
  // Array
  // TODO: define better types for $all and $elemMatch
  $all?: any
  $elemMatch?: any
  $size?: any
  // Bitwise
  $bitsAllClear?: any
  $bitsAllSet?: any
  $bitsAnyClear?: any
  $bitsAnySet?: any
}

interface IUpdateQuery {
  $currentDate?: Date | { $type: 'date' | 'timestamp' }
  $inc?: { [key: string]: number | undefined }
  $min?: { [key: string]: number | undefined }
  $max?: { [key: string]: number | undefined }
  $mul?: { [key: string]: number | undefined }
  $rename?: { [key: string]: any }
  $set?: { [key: string]: any }
  $setOnInsert?: { [key: string]: any }
  $unset?: { [key: string]: any }
  $addToSet?: { [key: string]: any }
  $pop?: { [key: string]: any }
  $pull?: { [key: string]: any }
  $push?: { [key: string]: any }
  $bit?: {
    [key: string]: { [key in 'and' | 'or' | 'xor']?: number }
  }
}

interface IPreUpdateQuery {
  $inc?: { [key: string]: number | undefined }
  $set?: { [key: string]: any }
  $push?: { [key: string]: any }
  $where?: string | IFunction
}

interface IFindProjection {
  projection?: {
    [key: string]: number | boolean | any
  }
  sort?: {
    [key: string]: 1 | -1
  }
  maxTimeMS?: number
  upsert?: boolean
  limit?: number
  skip?: number
  returnOriginal?: boolean
  collation?: CollationDocument
}

interface CollationDocument {
  locale: string
  strength?: number
  caseLevel?: boolean
  caseFirst?: string
  numericOrdering?: boolean
  alternate?: string
  maxVariable?: string
  backwards?: boolean
  normalization?: boolean
}
