/** @format */

type IActivityInfo = ICommonActivityInfo & ICustomActivityInfo

interface ICustomActivityInfo {
  collectCardConfig: {
    freeTimes: number
    freeType: number
    joinLimit: number
  }
  shareImage: string
  shareTitle: string
  shareSubtitle: string
}
interface ICommonActivityInfo {
  _id?: string
  id?: string
  openId: string
  rule: string
  startTime: number
  endTime: number
  title: string
  deleteStatus: number
  openPrizeStatus?: number
  remark?: string
  createTime: number
  updateTime: number
  awardReceiveExpiredTime?: number
  activtiyInfoUserNick: string
  tasks?: ITasks
}

type ITaskType =
  | 'follow'
  | 'member'
  | 'sign'
  | 'exchangeCredits'
  | 'browseGoods'
  | 'orderGoods'
  | 'collectGoods'
  | 'jumpLink'
  | 'invites'
  | 'orderDepositGoods'

type ITasks = { [key in ITaskType]: ITaskConfig }

interface ITaskConfig {
  title?: string // 任务标题
  value: number // 任奖奖励
  times?: number // 任务为每日限次次数值
  taskRateType?: number // 任务频率类型
  link?: string // 任务链接
  itemIds?: string // 任务商品
  checked?: boolean // 是否选中（B端需勾选时）
}
